package JSci.chemistry.periodictable;

/**
* A class representing gold.
* @version 1.5
* @author Mark Hale
*/
public final class Gold extends TransitionMetal {
        /**
        * Constructs gold.
        */
        public Gold() {}
        /**
        * Returns the atomic number.
        * @return 79
        */
        public int atomicNumber() {return 79;}
        /**
        * Returns the mass number.
        * @return 197
        */
        public int massNumber() {return 197;}
        /**
        * Returns the electronegativity.
        * @return 2.54
        */
        public double electronegativity() {return 2.54;}
        /**
        * Returns the covalent radius.
        * @return 1.34
        */
        public double covalentRadius() {return 1.34;}
        /**
        * Returns the atomic radius.
        * @return 1.79
        */
        public double atomicRadius() {return 1.79;}
        /**
        * Returns the melting point.
        * @return 1337.5
        */
        public double meltingPoint() {return 1337.5;}
        /**
        * Returns the boiling point.
        * @return 3130.0
        */
        public double boilingPoint() {return 3130.0;}
        /**
        * Returns the density (293K).
        * @return 19.32
        */
        public double density() {return 19.32;}
        /**
        * Returns the specific heat.
        * @return 0.128
        */
        public double specificHeat() {return 0.128;}
        /**
        * Returns the electrical conductivity.
        * @return 0.452e6
        */
        public double electricalConductivity() {return 0.452e6;}
        /**
        * Returns the thermal conductivity.
        * @return 3.17
        */
        public double thermalConductivity() {return 3.17;}
        /**
        * Returns the chemical symbol.
        * @return Au
        */
        public String toString() {
                return new String("Au");
        }
}

