package JSci.chemistry.periodictable;

/**
* A class representing hafnium.
* @version 1.5
* @author Mark Hale
*/
public final class Hafnium extends TransitionMetal {
        /**
        * Constructs hafnium.
        */
        public Hafnium() {}
        /**
        * Returns the atomic number.
        * @return 72
        */
        public int atomicNumber() {return 72;}
        /**
        * Returns the mass number.
        * @return 178
        */
        public int massNumber() {return 178;}
        /**
        * Returns the electronegativity.
        * @return 1.3
        */
        public double electronegativity() {return 1.3;}
        /**
        * Returns the covalent radius.
        * @return 1.44
        */
        public double covalentRadius() {return 1.44;}
        /**
        * Returns the atomic radius.
        * @return 2.16
        */
        public double atomicRadius() {return 2.16;}
        /**
        * Returns the melting point.
        * @return 2500.0
        */
        public double meltingPoint() {return 2500.0;}
        /**
        * Returns the boiling point.
        * @return 4876.0
        */
        public double boilingPoint() {return 4876.0;}
        /**
        * Returns the density (293K).
        * @return 13.2
        */
        public double density() {return 13.2;}
        /**
        * Returns the specific heat.
        * @return 0.14
        */
        public double specificHeat() {return 0.14;}
        /**
        * Returns the electrical conductivity.
        * @return 0.0312e6
        */
        public double electricalConductivity() {return 0.0312e6;}
        /**
        * Returns the thermal conductivity.
        * @return 0.230
        */
        public double thermalConductivity() {return 0.230;}
        /**
        * Returns the chemical symbol.
        * @return Hf
        */
        public String toString() {
                return new String("Hf");
        }
}

