package JSci.chemistry.periodictable;

/**
* A class representing helium.
* @version 1.5
* @author Mark Hale
*/
public final class Helium extends NobleGas {
        /**
        * Constructs helium.
        */
        public Helium() {}
        /**
        * Returns the atomic number.
        * @return 2
        */
        public int atomicNumber() {return 2;}
        /**
        * Returns the mass number.
        * @return 4
        */
        public int massNumber() {return 4;}
        /**
        * Returns the electronegativity.
        * @return 0.0
        */
        public double electronegativity() {return 0.0;}
        /**
        * Returns the covalent radius.
        * @return 0.93
        */
        public double covalentRadius() {return 0.93;}
        /**
        * Returns the atomic radius.
        * @return 0.49
        */
        public double atomicRadius() {return 0.49;}
        /**
        * Returns the melting point.
        * @return 0.95
        */
        public double meltingPoint() {return 0.95;}
        /**
        * Returns the boiling point.
        * @return 4.215
        */
        public double boilingPoint() {return 4.215;}
        /**
        * Returns the density (293K).
        * @return 0.0001787
        */
        public double density() {return 0.0001787;}
        /**
        * Returns the specific heat.
        * @return 5.193
        */
        public double specificHeat() {return 5.193;}
        /**
        * Returns the electrical conductivity.
        * @return 0.0
        */
        public double electricalConductivity() {return 0.0;}
        /**
        * Returns the thermal conductivity.
        * @return 0.00152
        */
        public double thermalConductivity() {return 0.00152;}
        /**
        * Returns the chemical symbol.
        * @return He
        */
        public String toString() {
                return new String("He");
        }
}

