package JSci.chemistry.periodictable;

/**
* A class representing iodine.
* @version 1.5
* @author Mark Hale
*/
public final class Iodine extends Halogen {
        /**
        * Constructs iodine.
        */
        public Iodine() {}
        /**
        * Returns the atomic number.
        * @return 53
        */
        public int atomicNumber() {return 53;}
        /**
        * Returns the mass number.
        * @return 127
        */
        public int massNumber() {return 127;}
        /**
        * Returns the electronegativity.
        * @return 2.66
        */
        public double electronegativity() {return 2.66;}
        /**
        * Returns the covalent radius.
        * @return 1.333
        */
        public double covalentRadius() {return 1.333;}
        /**
        * Returns the atomic radius.
        * @return 1.32
        */
        public double atomicRadius() {return 1.32;}
        /**
        * Returns the melting point.
        * @return 386.7
        */
        public double meltingPoint() {return 386.7;}
        /**
        * Returns the boiling point.
        * @return 458.4
        */
        public double boilingPoint() {return 458.4;}
        /**
        * Returns the density (293K).
        * @return 4.93
        */
        public double density() {return 4.93;}
        /**
        * Returns the specific heat.
        * @return 0.214
        */
        public double specificHeat() {return 0.214;}
        /**
        * Returns the electrical conductivity.
        * @return 8.0e-10
        */
        public double electricalConductivity() {return 8.0e-10;}
        /**
        * Returns the thermal conductivity.
        * @return 0.00449
        */
        public double thermalConductivity() {return 0.00449;}
        /**
        * Returns the chemical symbol.
        * @return I
        */
        public String toString() {
                return new String("I");
        }
}

