package JSci.chemistry.periodictable;

/**
* A class representing krypton.
* @version 1.5
* @author Mark Hale
*/
public final class Krypton extends NobleGas {
        /**
        * Constructs krypton.
        */
        public Krypton() {}
        /**
        * Returns the atomic number.
        * @return 36
        */
        public int atomicNumber() {return 36;}
        /**
        * Returns the mass number.
        * @return 84
        */
        public int massNumber() {return 84;}
        /**
        * Returns the electronegativity.
        * @return 0.0
        */
        public double electronegativity() {return 0.0;}
        /**
        * Returns the covalent radius.
        * @return 1.12
        */
        public double covalentRadius() {return 1.12;}
        /**
        * Returns the atomic radius.
        * @return 1.03
        */
        public double atomicRadius() {return 1.03;}
        /**
        * Returns the melting point.
        * @return 115.78
        */
        public double meltingPoint() {return 115.78;}
        /**
        * Returns the boiling point.
        * @return 119.8
        */
        public double boilingPoint() {return 119.8;}
        /**
        * Returns the density (293K).
        * @return 0.003708
        */
        public double density() {return 0.003708;}
        /**
        * Returns the specific heat.
        * @return 0.248
        */
        public double specificHeat() {return 0.248;}
        /**
        * Returns the electrical conductivity.
        * @return 0.0
        */
        public double electricalConductivity() {return 0.0;}
        /**
        * Returns the thermal conductivity.
        * @return 0.0000949
        */
        public double thermalConductivity() {return 0.0000949;}
        /**
        * Returns the chemical symbol.
        * @return Kr
        */
        public String toString() {
                return new String("Kr");
        }
}

