package JSci.chemistry.periodictable;

/**
* A class representing lanthanum.
* @version 1.5
* @author Mark Hale
*/
public final class Lanthanum extends TransitionMetal {
        /**
        * Constructs lanthanum.
        */
        public Lanthanum() {}
        /**
        * Returns the atomic number.
        * @return 57
        */
        public int atomicNumber() {return 57;}
        /**
        * Returns the mass number.
        * @return 139
        */
        public int massNumber() {return 139;}
        /**
        * Returns the electronegativity.
        * @return 1.10
        */
        public double electronegativity() {return 1.10;}
        /**
        * Returns the covalent radius.
        * @return 1.69
        */
        public double covalentRadius() {return 1.69;}
        /**
        * Returns the atomic radius.
        * @return 2.74
        */
        public double atomicRadius() {return 2.74;}
        /**
        * Returns the melting point.
        * @return 1193.0
        */
        public double meltingPoint() {return 1193.0;}
        /**
        * Returns the boiling point.
        * @return 3730.0
        */
        public double boilingPoint() {return 3730.0;}
        /**
        * Returns the density (293K).
        * @return 6.7
        */
        public double density() {return 6.7;}
        /**
        * Returns the specific heat.
        * @return 0.19
        */
        public double specificHeat() {return 0.19;}
        /**
        * Returns the electrical conductivity.
        * @return 0.0126e6
        */
        public double electricalConductivity() {return 0.0126e6;}
        /**
        * Returns the thermal conductivity.
        * @return 0.135
        */
        public double thermalConductivity() {return 0.135;}
        /**
        * Returns the chemical symbol.
        * @return La
        */
        public String toString() {
                return new String("La");
        }
}

