package JSci.chemistry.periodictable;

/**
* A class representing lead.
* @version 1.5
* @author Mark Hale
*/
public final class Lead extends Metal {
        /**
        * Constructs lead.
        */
        public Lead() {}
        /**
        * Returns the atomic number.
        * @return 82
        */
        public int atomicNumber() {return 82;}
        /**
        * Returns the mass number.
        * @return 207
        */
        public int massNumber() {return 207;}
        /**
        * Returns the electronegativity.
        * @return 2.33
        */
        public double electronegativity() {return 2.33;}
        /**
        * Returns the covalent radius.
        * @return 1.54
        */
        public double covalentRadius() {return 1.54;}
        /**
        * Returns the atomic radius.
        * @return 1.81
        */
        public double atomicRadius() {return 1.81;}
        /**
        * Returns the melting point.
        * @return 600.6
        */
        public double meltingPoint() {return 600.6;}
        /**
        * Returns the boiling point.
        * @return 2023.0
        */
        public double boilingPoint() {return 2023.0;}
        /**
        * Returns the density (293K).
        * @return 11.34
        */
        public double density() {return 11.34;}
        /**
        * Returns the specific heat.
        * @return 0.13
        */
        public double specificHeat() {return 0.13;}
        /**
        * Returns the electrical conductivity.
        * @return 0.0481e6
        */
        public double electricalConductivity() {return 0.0481e6;}
        /**
        * Returns the thermal conductivity.
        * @return 0.353
        */
        public double thermalConductivity() {return 0.353;}
        /**
        * Returns the chemical symbol.
        * @return Pb
        */
        public String toString() {
                return new String("Pb");
        }
}

