package JSci.chemistry.periodictable;

/**
* A class representing lithium.
* @version 1.5
* @author Mark Hale
*/
public final class Lithium extends AlkaliMetal {
        /**
        * Constructs lithium.
        */
        public Lithium() {}
        /**
        * Returns the atomic number.
        * @return 3
        */
        public int atomicNumber() {return 3;}
        /**
        * Returns the mass number.
        * @return 7
        */
        public int massNumber() {return 7;}
        /**
        * Returns the electronegativity.
        * @return 0.98
        */
        public double electronegativity() {return 0.98;}
        /**
        * Returns the covalent radius.
        * @return 1.23
        */
        public double covalentRadius() {return 1.23;}
        /**
        * Returns the atomic radius.
        * @return 2.05
        */
        public double atomicRadius() {return 2.05;}
        /**
        * Returns the melting point.
        * @return 453.7
        */
        public double meltingPoint() {return 453.7;}
        /**
        * Returns the boiling point.
        * @return 1615.0
        */
        public double boilingPoint() {return 1615.0;}
        /**
        * Returns the density (293K).
        * @return 0.53
        */
        public double density() {return 0.53;}
        /**
        * Returns the specific heat.
        * @return 3.6
        */
        public double specificHeat() {return 3.6;}
        /**
        * Returns the electrical conductivity.
        * @return 0.108e6
        */
        public double electricalConductivity() {return 0.108e6;}
        /**
        * Returns the thermal conductivity.
        * @return 0.847
        */
        public double thermalConductivity() {return 0.847;}
        /**
        * Returns the chemical symbol.
        * @return Li
        */
        public String toString() {
                return new String("Li");
        }
}

