package JSci.chemistry.periodictable;

/**
* A class representing magnesium.
* @version 1.5
* @author Mark Hale
*/
public final class Magnesium extends AlkaliEarthMetal {
        /**
        * Constructs magnesium.
        */
        public Magnesium() {}
        /**
        * Returns the atomic number.
        * @return 12
        */
        public int atomicNumber() {return 12;}
        /**
        * Returns the mass number.
        * @return 24
        */
        public int massNumber() {return 24;}
        /**
        * Returns the electronegativity.
        * @return 1.31
        */
        public double electronegativity() {return 1.31;}
        /**
        * Returns the covalent radius.
        * @return 1.36
        */
        public double covalentRadius() {return 1.36;}
        /**
        * Returns the atomic radius.
        * @return 1.72
        */
        public double atomicRadius() {return 1.72;}
        /**
        * Returns the melting point.
        * @return 922.0
        */
        public double meltingPoint() {return 922.0;}
        /**
        * Returns the boiling point.
        * @return 1363.0
        */
        public double boilingPoint() {return 1363.0;}
        /**
        * Returns the density (293K).
        * @return 1.738
        */
        public double density() {return 1.738;}
        /**
        * Returns the specific heat.
        * @return 1.02
        */
        public double specificHeat() {return 1.02;}
        /**
        * Returns the electrical conductivity.
        * @return 0.226e6
        */
        public double electricalConductivity() {return 0.226e6;}
        /**
        * Returns the thermal conductivity.
        * @return 1.56
        */
        public double thermalConductivity() {return 1.56;}
        /**
        * Returns the chemical symbol.
        * @return Mg
        */
        public String toString() {
                return new String("Mg");
        }
}

