package JSci.chemistry.periodictable;

/**
* A class representing molybdenum.
* @version 1.5
* @author Mark Hale
*/
public final class Molybdenum extends TransitionMetal {
        /**
        * Constructs molybdenum.
        */
        public Molybdenum() {}
        /**
        * Returns the atomic number.
        * @return 42
        */
        public int atomicNumber() {return 42;}
        /**
        * Returns the mass number.
        * @return 96
        */
        public int massNumber() {return 96;}
        /**
        * Returns the electronegativity.
        * @return 2.16
        */
        public double electronegativity() {return 2.16;}
        /**
        * Returns the covalent radius.
        * @return 1.29
        */
        public double covalentRadius() {return 1.29;}
        /**
        * Returns the atomic radius.
        * @return 2.01
        */
        public double atomicRadius() {return 2.01;}
        /**
        * Returns the melting point.
        * @return 2890.0
        */
        public double meltingPoint() {return 2890.0;}
        /**
        * Returns the boiling point.
        * @return 4912.0
        */
        public double boilingPoint() {return 4912.0;}
        /**
        * Returns the density (293K).
        * @return 10.2
        */
        public double density() {return 10.2;}
        /**
        * Returns the specific heat.
        * @return 0.25
        */
        public double specificHeat() {return 0.25;}
        /**
        * Returns the electrical conductivity.
        * @return 0.187e6
        */
        public double electricalConductivity() {return 0.187e6;}
        /**
        * Returns the thermal conductivity.
        * @return 1.38
        */
        public double thermalConductivity() {return 1.38;}
        /**
        * Returns the chemical symbol.
        * @return Mo
        */
        public String toString() {
                return new String("Mo");
        }
}

