package JSci.chemistry.periodictable;

/**
* A class representing niobium.
* @version 1.5
* @author Mark Hale
*/
public final class Niobium extends TransitionMetal {
        /**
        * Constructs niobium.
        */
        public Niobium() {}
        /**
        * Returns the atomic number.
        * @return 41
        */
        public int atomicNumber() {return 41;}
        /**
        * Returns the mass number.
        * @return 93
        */
        public int massNumber() {return 93;}
        /**
        * Returns the electronegativity.
        * @return 1.6
        */
        public double electronegativity() {return 1.6;}
        /**
        * Returns the covalent radius.
        * @return 1.34
        */
        public double covalentRadius() {return 1.34;}
        /**
        * Returns the atomic radius.
        * @return 2.08
        */
        public double atomicRadius() {return 2.08;}
        /**
        * Returns the melting point.
        * @return 2740.0
        */
        public double meltingPoint() {return 2740.0;}
        /**
        * Returns the boiling point.
        * @return 5017.0
        */
        public double boilingPoint() {return 5017.0;}
        /**
        * Returns the density (293K).
        * @return 8.57
        */
        public double density() {return 8.57;}
        /**
        * Returns the specific heat.
        * @return 0.26
        */
        public double specificHeat() {return 0.26;}
        /**
        * Returns the electrical conductivity.
        * @return 0.0693e6
        */
        public double electricalConductivity() {return 0.0693e6;}
        /**
        * Returns the thermal conductivity.
        * @return 0.537
        */
        public double thermalConductivity() {return 0.537;}
        /**
        * Returns the chemical symbol.
        * @return Nb
        */
        public String toString() {
                return new String("Nb");
        }
}

