package JSci.chemistry.periodictable;

/**
* A class representing nitrogen.
* @version 1.5
* @author Mark Hale
*/
public final class Nitrogen extends NonMetal {
        /**
        * Constructs nitrogen.
        */
        public Nitrogen() {}
        /**
        * Returns the atomic number.
        * @return 7
        */
        public int atomicNumber() {return 7;}
        /**
        * Returns the mass number.
        * @return 14
        */
        public int massNumber() {return 14;}
        /**
        * Returns the electronegativity.
        * @return 3.04
        */
        public double electronegativity() {return 3.04;}
        /**
        * Returns the covalent radius.
        * @return 0.70
        */
        public double covalentRadius() {return 0.70;}
        /**
        * Returns the atomic radius.
        * @return 0.75
        */
        public double atomicRadius() {return 0.75;}
        /**
        * Returns the melting point.
        * @return 63.14
        */
        public double meltingPoint() {return 63.14;}
        /**
        * Returns the boiling point.
        * @return 77.35
        */
        public double boilingPoint() {return 77.35;}
        /**
        * Returns the density (293K).
        * @return 0.0012506
        */
        public double density() {return 0.0012506;}
        /**
        * Returns the specific heat.
        * @return 1.04
        */
        public double specificHeat() {return 1.04;}
        /**
        * Returns the electrical conductivity.
        * @return Unknown
        */
        public double electricalConductivity() {return Double.NaN;}
        /**
        * Returns the thermal conductivity.
        * @return 0.0002598
        */
        public double thermalConductivity() {return 0.0002598;}
        /**
        * Returns the chemical symbol.
        * @return N
        */
        public String toString() {
                return new String("N");
        }
}

