package JSci.chemistry.periodictable;

/**
* A class representing osmium.
* @version 1.5
* @author Mark Hale
*/
public final class Osmium extends TransitionMetal {
        /**
        * Constructs osmium.
        */
        public Osmium() {}
        /**
        * Returns the atomic number.
        * @return 76
        */
        public int atomicNumber() {return 76;}
        /**
        * Returns the mass number.
        * @return 190
        */
        public int massNumber() {return 190;}
        /**
        * Returns the electronegativity.
        * @return 2.2
        */
        public double electronegativity() {return 2.2;}
        /**
        * Returns the covalent radius.
        * @return 1.26
        */
        public double covalentRadius() {return 1.26;}
        /**
        * Returns the atomic radius.
        * @return 1.92
        */
        public double atomicRadius() {return 1.92;}
        /**
        * Melting point.
        * @return 3300.0
        */
        public double meltingPoint() {return 3300.0;}
        /**
        * Returns the boiling point.
        * @return 5285.0
        */
        public double boilingPoint() {return 5285.0;}
        /**
        * Returns the density (293K).
        * @return 22.40
        */
        public double density() {return 22.40;}
        /**
        * Returns the specific heat.
        * @return 0.13
        */
        public double specificHeat() {return 0.13;}
        /**
        * Returns the electrical conductivity.
        * @return 0.109e6
        */
        public double electricalConductivity() {return 0.109e6;}
        /**
        * Returns the thermal conductivity.
        * @return 0.876
        */
        public double thermalConductivity() {return 0.876;}
        /**
        * Returns the chemical symbol.
        * @return Os
        */
        public String toString() {
                return new String("Os");
        }
}

