package JSci.chemistry.periodictable;

/**
* A class representing phosphorus.
* @version 1.5
* @author Mark Hale
*/
public final class Phosphorus extends NonMetal {
        /**
        * Constructs phosphorus.
        */
        public Phosphorus() {}
        /**
        * Returns the atomic number.
        * @return 15
        */
        public int atomicNumber() {return 15;}
        /**
        * Returns the mass number.
        * @return 31
        */
        public int massNumber() {return 31;}
        /**
        * Returns the electronegativity.
        * @return 2.19
        */
        public double electronegativity() {return 2.19;}
        /**
        * Returns the covalent radius.
        * @return 1.10
        */
        public double covalentRadius() {return 1.10;}
        /**
        * Returns the atomic radius.
        * @return 1.23
        */
        public double atomicRadius() {return 1.23;}
        /**
        * Returns the melting point.
        * @return 317.3
        */
        public double meltingPoint() {return 317.3;}
        /**
        * Returns the boiling point.
        * @return 550.0
        */
        public double boilingPoint() {return 550.0;}
        /**
        * Returns the density (293K).
        * @return 1.82
        */
        public double density() {return 1.82;}
        /**
        * Returns the specific heat.
        * @return 0.77
        */
        public double specificHeat() {return 0.77;}
        /**
        * Returns the electrical conductivity.
        * @return 1.0e-11
        */
        public double electricalConductivity() {return 1.0e-11;}
        /**
        * Returns the thermal conductivity.
        * @return 0.00235
        */
        public double thermalConductivity() {return 0.00235;}
        /**
        * Returns the chemical symbol.
        * @return P
        */
        public String toString() {
                return new String("P");
        }
}

