package JSci.chemistry.periodictable;

/**
* A class representing polonium.
* @version 1.5
* @author Mark Hale
*/
public final class Polonium extends Metal {
        /**
        * Constructs polonium.
        */
        public Polonium() {}
        /**
        * Returns the atomic number.
        * @return 84
        */
        public int atomicNumber() {return 84;}
        /**
        * Returns the mass number.
        * @return 210
        */
        public int massNumber() {return 210;}
        /**
        * Returns the electronegativity.
        * @return 2.0
        */
        public double electronegativity() {return 2.0;}
        /**
        * Returns the covalent radius.
        * @return 1.53
        */
        public double covalentRadius() {return 1.53;}
        /**
        * Returns the atomic radius.
        * @return 1.53
        */
        public double atomicRadius() {return 1.53;}
        /**
        * Returns the melting point.
        * @return 527.0
        */
        public double meltingPoint() {return 527.0;}
        /**
        * Returns the boiling point.
        * @return 1235.0
        */
        public double boilingPoint() {return 1235.0;}
        /**
        * Returns the density (293K).
        * @return 9.4
        */
        public double density() {return 9.4;}
        /**
        * Returns the specific heat.
        * @return 0.12
        */
        public double specificHeat() {return 0.12;}
        /**
        * Returns the electrical conductivity.
        * @return 0.0219e6
        */
        public double electricalConductivity() {return 0.0219e6;}
        /**
        * Returns the thermal conductivity.
        * @return 0.20
        */
        public double thermalConductivity() {return 0.20;}
        /**
        * Returns the chemical symbol.
        * @return Po
        */
        public String toString() {
                return new String("Po");
        }
}

