package JSci.chemistry.periodictable;

/**
* A class representing promethium.
* @version 1.5
* @author Mark Hale
*/
public final class Promethium extends RareEarthMetal {
        /**
        * Constructs promethium.
        */
        public Promethium() {}
        /**
        * Returns the atomic number.
        * @return 61
        */
        public int atomicNumber() {return 61;}
        /**
        * Returns the mass number.
        * @return 145
        */
        public int massNumber() {return 145;}
        /**
        * Returns the electronegativity.
        * @return 1.13
        */
        public double electronegativity() {return 1.13;}
        /**
        * Returns the covalent radius.
        * @return 1.63
        */
        public double covalentRadius() {return 1.63;}
        /**
        * Returns the atomic radius.
        * @return 2.62
        */
        public double atomicRadius() {return 2.62;}
        /**
        * Returns the melting point.
        * @return 1204.0
        */
        public double meltingPoint() {return 1204.0;}
        /**
        * Returns the boiling point.
        * @return 3785.0
        */
        public double boilingPoint() {return 3785.0;}
        /**
        * Returns the density (293K).
        * @return 6.475
        */
        public double density() {return 6.475;}
        /**
        * Returns the specific heat.
        * @return 0.18
        */
        public double specificHeat() {return 0.18;}
        /**
        * Returns the electrical conductivity.
        * @return Unknown
        */
        public double electricalConductivity() {return Double.NaN;}
        /**
        * Returns the thermal conductivity.
        * @return 0.179
        */
        public double thermalConductivity() {return 0.179;}
        /**
        * Returns the chemical symbol.
        * @return Pm
        */
        public String toString() {
                return new String("Pm");
        }
}

