package JSci.chemistry.periodictable;

/**
* A class representing protactinium.
* @version 1.5
* @author Mark Hale
*/
public final class Protactinium extends RareEarthMetal {
        /**
        * Constructs protactinium.
        */
        public Protactinium() {}
        /**
        * Returns the atomic number.
        * @return 91
        */
        public int atomicNumber() {return 91;}
        /**
        * Returns the mass number.
        * @return 231
        */
        public int massNumber() {return 231;}
        /**
        * Returns the electronegativity.
        * @return 1.5
        */
        public double electronegativity() {return 1.5;}
        /**
        * Returns the covalent radius.
        * @return Unknown
        */
        public double covalentRadius() {return Double.NaN;}
        /**
        * Returns the atomic radius.
        * @return Unknown
        */
        public double atomicRadius() {return Double.NaN;}
        /**
        * Returns the melting point.
        * @return Unknown
        */
        public double meltingPoint() {return Double.NaN;}
        /**
        * Returns the boiling point.
        * @return Unknown
        */
        public double boilingPoint() {return Double.NaN;}
        /**
        * Returns the density (293K).
        * @return 15.4
        */
        public double density() {return 15.4;}
        /**
        * Returns the specific heat.
        * @return 0.12
        */
        public double specificHeat() {return 0.12;}
        /**
        * Returns the electrical conductivity.
        * @return 0.0529e6
        */
        public double electricalConductivity() {return 0.0529e6;}
        /**
        * Returns the thermal conductivity.
        * @return 0.47
        */
        public double thermalConductivity() {return 0.47;}
        /**
        * Returns the chemical symbol.
        * @return Pa
        */
        public String toString() {
                return new String("Pa");
        }
}

