package JSci.chemistry.periodictable;

/**
* A class representing rubidium.
* @version 1.5
* @author Mark Hale
*/
public final class Rubidium extends AlkaliMetal {
        /**
        * Constructs rubidium.
        */
        public Rubidium() {}
        /**
        * Returns the atomic number.
        * @return 37
        */
        public int atomicNumber() {return 37;}
        /**
        * Returns the mass number.
        * @return 85
        */
        public int massNumber() {return 85;}
        /**
        * Returns the electronegativity.
        * @return 0.82
        */
        public double electronegativity() {return 0.82;}
        /**
        * Returns the covalent radius.
        * @return 2.16
        */
        public double covalentRadius() {return 2.16;}
        /**
        * Returns the atomic radius.
        * @return 2.98
        */
        public double atomicRadius() {return 2.98;}
        /**
        * Returns the melting point.
        * @return 312.64
        */
        public double meltingPoint() {return 312.64;}
        /**
        * Returns the boiling point.
        * @return 961.0
        */
        public double boilingPoint() {return 961.0;}
        /**
        * Returns the density (293K).
        * @return 1.53
        */
        public double density() {return 1.53;}
        /**
        * Returns the specific heat.
        * @return 0.363
        */
        public double specificHeat() {return 0.363;}
        /**
        * Returns the electrical conductivity.
        * @return 0.0779e6
        */
        public double electricalConductivity() {return 0.0779e6;}
        /**
        * Returns the thermal conductivity.
        * @return 0.582
        */
        public double thermalConductivity() {return 0.582;}
        /**
        * Returns the chemical symbol.
        * @return Rb
        */
        public String toString() {
                return new String("Rb");
        }
}

