package JSci.chemistry.periodictable;

/**
* A class representing samarium.
* @version 1.5
* @author Mark Hale
*/
public final class Samarium extends RareEarthMetal {
        /**
        * Constructs samarium.
        */
        public Samarium() {}
        /**
        * Returns the atomic number.
        * @return 62
        */
        public int atomicNumber() {return 62;}
        /**
        * Returns the mass number.
        * @return 150
        */
        public int massNumber() {return 150;}
        /**
        * Returns the electronegativity.
        * @return 1.17
        */
        public double electronegativity() {return 1.17;}
        /**
        * Returns the covalent radius.
        * @return 1.62
        */
        public double covalentRadius() {return 1.62;}
        /**
        * Returns the atomic radius.
        * @return 2.59
        */
        public double atomicRadius() {return 2.59;}
        /**
        * Returns the melting point.
        * @return 1345.0
        */
        public double meltingPoint() {return 1345.0;}
        /**
        * Returns the boiling point.
        * @return 2064.0
        */
        public double boilingPoint() {return 2064.0;}
        /**
        * Returns the density (293K).
        * @return 7.54
        */
        public double density() {return 7.54;}
        /**
        * Returns the specific heat.
        * @return 0.20
        */
        public double specificHeat() {return 0.20;}
        /**
        * Returns the electrical conductivity.
        * @return 0.956e4
        */
        public double electricalConductivity() {return 0.956e4;}
        /**
        * Returns the thermal conductivity.
        * @return 0.133
        */
        public double thermalConductivity() {return 0.133;}
        /**
        * Returns the chemical symbol.
        * @return Sm
        */
        public String toString() {
                return new String("Sm");
        }
}

