package JSci.chemistry.periodictable;

/**
* A class representing selenium.
* @version 1.5
* @author Mark Hale
*/
public final class Selenium extends NonMetal {
        /**
        * Constructs selenium.
        */
        public Selenium() {}
        /**
        * Returns the atomic number.
        * @return 34
        */
        public int atomicNumber() {return 34;}
        /**
        * Returns the mass number.
        * @return 79
        */
        public int massNumber() {return 79;}
        /**
        * Returns the electronegativity.
        * @return 2.55
        */
        public double electronegativity() {return 2.55;}
        /**
        * Returns the covalent radius.
        * @return 1.17
        */
        public double covalentRadius() {return 1.17;}
        /**
        * Returns the atomic radius.
        * @return 1.22
        */
        public double atomicRadius() {return 1.22;}
        /**
        * Returns the melting point.
        * @return 494.0
        */
        public double meltingPoint() {return 494.0;}
        /**
        * Returns the boiling point.
        * @return 958.0
        */
        public double boilingPoint() {return 958.0;}
        /**
        * Returns the density (293K).
        * @return 4.79
        */
        public double density() {return 4.79;}
        /**
        * Returns the specific heat.
        * @return 0.32
        */
        public double specificHeat() {return 0.32;}
        /**
        * Returns the electrical conductivity.
        * @return 1.0e-6
        */
        public double electricalConductivity() {return 1.0e-6;}
        /**
        * Returns the thermal conductivity.
        * @return 0.0204
        */
        public double thermalConductivity() {return 0.0204;}
        /**
        * Returns the chemical symbol.
        * @return Se
        */
        public String toString() {
                return new String("Se");
        }
}

