package JSci.chemistry.periodictable;

/**
* A class representing silver.
* @version 1.5
* @author Mark Hale
*/
public final class Silver extends TransitionMetal {
        /**
        * Constructs silver.
        */
        public Silver() {}
        /**
        * Returns the atomic number.
        * @return 47
        */
        public int atomicNumber() {return 47;}
        /**
        * Returns the mass number.
        * @return 108
        */
        public int massNumber() {return 108;}
        /**
        * Returns the electronegativity.
        * @return 1.93
        */
        public double electronegativity() {return 1.93;}
        /**
        * Returns the covalent radius.
        * @return 1.34
        */
        public double covalentRadius() {return 1.34;}
        /**
        * Returns the atomic radius.
        * @return 1.75
        */
        public double atomicRadius() {return 1.75;}
        /**
        * Returns the melting point.
        * @return 1234.0
        */
        public double meltingPoint() {return 1234.0;}
        /**
        * Returns the boiling point.
        * @return 2436.0
        */
        public double boilingPoint() {return 2436.0;}
        /**
        * Returns the density (293K).
        * @return 10.5
        */
        public double density() {return 10.5;}
        /**
        * Returns the specific heat.
        * @return 0.235
        */
        public double specificHeat() {return 0.235;}
        /**
        * Returns the electrical conductivity.
        * @return 0.630e6
        */
        public double electricalConductivity() {return 0.630e6;}
        /**
        * Returns the thermal conductivity.
        * @return 4.29
        */
        public double thermalConductivity() {return 4.29;}
        /**
        * Returns the chemical symbol.
        * @return Ag
        */
        public String toString() {
                return new String("Ag");
        }
}

