package JSci.chemistry.periodictable;

/**
* A class representing strontium.
* @version 1.5
* @author Mark Hale
*/
public final class Strontium extends AlkaliEarthMetal {
        /**
        * Constructs strontium.
        */
        public Strontium() {}
        /**
        * Returns the atomic number.
        * @return 38
        */
        public int atomicNumber() {return 38;}
        /**
        * Returns the mass number.
        * @return 88
        */
        public int massNumber() {return 88;}
        /**
        * Returns the electronegativity.
        * @return 0.95
        */
        public double electronegativity() {return 0.95;}
        /**
        * Returns the covalent radius.
        * @return 1.92
        */
        public double covalentRadius() {return 1.92;}
        /**
        * Returns the atomic radius.
        * @return 2.45
        */
        public double atomicRadius() {return 2.45;}
        /**
        * Returns the melting point.
        * @return 1041.0
        */
        public double meltingPoint() {return 1041.0;}
        /**
        * Returns the boiling point.
        * @return 1650.0
        */
        public double boilingPoint() {return 1650.0;}
        /**
        * Returns the density (293K).
        * @return 2.6
        */
        public double density() {return 2.6;}
        /**
        * Returns the specific heat.
        * @return 0.30
        */
        public double specificHeat() {return 0.30;}
        /**
        * Returns the electrical conductivity.
        * @return 0.0762e6
        */
        public double electricalConductivity() {return 0.0762e6;}
        /**
        * Returns the thermal conductivity.
        * @return 0.353
        */
        public double thermalConductivity() {return 0.353;}
        /**
        * Returns the chemical symbol.
        * @return Sr
        */
        public String toString() {
                return new String("Sr");
        }
}

