package JSci.chemistry.periodictable;

/**
* A class representing technetium.
* @version 1.5
* @author Mark Hale
*/
public final class Technetium extends TransitionMetal {
        /**
        * Constructs technetium.
        */
        public Technetium() {}
        /**
        * Returns the atomic number.
        * @return 43
        */
        public int atomicNumber() {return 43;}
        /**
        * Returns the mass number.
        * @return 99
        */
        public int massNumber() {return 99;}
        /**
        * Returns the electronegativity.
        * @return 1.9
        */
        public double electronegativity() {return 1.9;}
        /**
        * Returns the covalent radius.
        * @return 1.27
        */
        public double covalentRadius() {return 1.27;}
        /**
        * Returns the atomic radius.
        * @return 1.95
        */
        public double atomicRadius() {return 1.95;}
        /**
        * Returns the melting point.
        * @return 2473.0
        */
        public double meltingPoint() {return 2473.0;}
        /**
        * Returns the boiling point.
        * @return 4538.0
        */
        public double boilingPoint() {return 4538.0;}
        /**
        * Returns the density (293K).
        * @return 11.5
        */
        public double density() {return 11.5;}
        /**
        * Returns the specific heat.
        * @return 0.21
        */
        public double specificHeat() {return 0.21;}
        /**
        * Returns the electrical conductivity.
        * @return 0.067e6
        */
        public double electricalConductivity() {return 0.067e6;}
        /**
        * Returns the thermal conductivity.
        * @return 0.506
        */
        public double thermalConductivity() {return 0.506;}
        /**
        * Returns the chemical symbol.
        * @return Tc
        */
        public String toString() {
                return new String("Tc");
        }
}

