package JSci.chemistry.periodictable;

/**
* A class representing terbium.
* @version 1.5
* @author Mark Hale
*/
public final class Terbium extends RareEarthMetal {
        /**
        * Constructs terbium.
        */
        public Terbium() {}
        /**
        * Returns the atomic number.
        * @return 65
        */
        public int atomicNumber() {return 65;}
        /**
        * Returns the mass number.
        * @return 159
        */
        public int massNumber() {return 159;}
        /**
        * Returns the electronegativity.
        * @return 1.2
        */
        public double electronegativity() {return 1.2;}
        /**
        * Returns the covalent radius.
        * @return 1.59
        */
        public double covalentRadius() {return 1.59;}
        /**
        * Returns the atomic radius.
        * @return 2.51
        */
        public double atomicRadius() {return 2.51;}
        /**
        * Returns the melting point.
        * @return 1630.0
        */
        public double meltingPoint() {return 1630.0;}
        /**
        * Returns the boiling point.
        * @return 3496.0
        */
        public double boilingPoint() {return 3496.0;}
        /**
        * Returns the density (293K).
        * @return 8.27
        */
        public double density() {return 8.27;}
        /**
        * Returns the specific heat.
        * @return 0.18
        */
        public double specificHeat() {return 0.18;}
        /**
        * Returns the electrical conductivity.
        * @return 0.00889e6
        */
        public double electricalConductivity() {return 0.00889e6;}
        /**
        * Returns the thermal conductivity.
        * @return 0.111
        */
        public double thermalConductivity() {return 0.111;}
        /**
        * Returns the chemical symbol.
        * @return Tb
        */
        public String toString() {
                return new String("Tb");
        }
}

