package JSci.chemistry.periodictable;

/**
* A class representing thallium.
* @version 1.5
* @author Mark Hale
*/
public final class Thallium extends Metal {
        /**
        * Constructs thallium.
        */
        public Thallium() {}
        /**
        * Returns the atomic number.
        * @return 81
        */
        public int atomicNumber() {return 81;}
        /**
        * Returns the mass number.
        * @return 204
        */
        public int massNumber() {return 204;}
        /**
        * Returns the electronegativity.
        * @return 2.04
        */
        public double electronegativity() {return 2.04;}
        /**
        * Returns the covalent radius.
        * @return 1.55
        */
        public double covalentRadius() {return 1.55;}
        /**
        * Returns the atomic radius.
        * @return 2.08
        */
        public double atomicRadius() {return 2.08;}
        /**
        * Returns the melting point.
        * @return 577.0
        */
        public double meltingPoint() {return 577.0;}
        /**
        * Returns the boiling point.
        * @return 1746.0
        */
        public double boilingPoint() {return 1746.0;}
        /**
        * Returns the density (293K).
        * @return 11.85
        */
        public double density() {return 11.85;}
        /**
        * Returns the specific heat.
        * @return 0.13
        */
        public double specificHeat() {return 0.13;}
        /**
        * Returns the electrical conductivity.
        * @return 0.0617e6
        */
        public double electricalConductivity() {return 0.0617e6;}
        /**
        * Returns the thermal conductivity.
        * @return 0.461
        */
        public double thermalConductivity() {return 0.461;}
        /**
        * Returns the chemical symbol.
        * @return Tl
        */
        public String toString() {
                return new String("Tl");
        }
}

