package JSci.chemistry.periodictable;

/**
* A class representing titanium.
* @version 1.5
* @author Mark Hale
*/
public final class Titanium extends TransitionMetal {
        /**
        * Constructs titanium.
        */
        public Titanium() {}
        /**
        * Returns the atomic number.
        * @return 22
        */
        public int atomicNumber() {return 22;}
        /**
        * Returns the mass number.
        * @return 48
        */
        public int massNumber() {return 48;}
        /**
        * Returns the electronegativity.
        * @return 1.54
        */
        public double electronegativity() {return 1.54;}
        /**
        * Returns the covalent radius.
        * @return 1.32
        */
        public double covalentRadius() {return 1.32;}
        /**
        * Returns the atomic radius.
        * @return 2.00
        */
        public double atomicRadius() {return 2.00;}
        /**
        * Returns the melting point.
        * @return 1943.0
        */
        public double meltingPoint() {return 1943.0;}
        /**
        * Returns the boiling point.
        * @return 3562.0
        */
        public double boilingPoint() {return 3562.0;}
        /**
        * Returns the density (293K).
        * @return 4.50
        */
        public double density() {return 4.50;}
        /**
        * Returns the specific heat.
        * @return 0.52
        */
        public double specificHeat() {return 0.52;}
        /**
        * Returns the electrical conductivity.
        * @return 0.0234e6
        */
        public double electricalConductivity() {return 0.0234e6;}
        /**
        * Returns the thermal conductivity.
        * @return 0.219
        */
        public double thermalConductivity() {return 0.219;}
        /**
        * Returns the chemical symbol.
        * @return Ti
        */
        public String toString() {
                return new String("Ti");
        }
}

