package JSci.chemistry.periodictable;

/**
* A class representing unnilquadium.
* @version 1.5
* @author Mark Hale
*/
public final class Unnilquadium extends TransitionMetal {
        /**
        * Constructs unnilquadium.
        */
        public Unnilquadium() {}
        /**
        * Returns the atomic number.
        * @return 104
        */
        public int atomicNumber() {return 104;}
        /**
        * Returns the mass number.
        * @return 261
        */
        public int massNumber() {return 261;}
        /**
        * Returns the electronegativity.
        * @return Unknown
        */
        public double electronegativity() {return Double.NaN;}
        /**
        * Returns the covalent radius.
        * @return Unknown
        */
        public double covalentRadius() {return Double.NaN;}
        /**
        * Returns the atomic radius.
        * @return Unknown
        */
        public double atomicRadius() {return Double.NaN;}
        /**
        * Returns the melting point.
        * @return Unknown
        */
        public double meltingPoint() {return Double.NaN;}
        /**
        * Returns the boiling point.
        * @return Unknown
        */
        public double boilingPoint() {return Double.NaN;}
        /**
        * Returns the density (293K).
        * @return Unknown
        */
        public double density() {return Double.NaN;}
        /**
        * Returns the specific heat.
        * @return Unknown
        */
        public double specificHeat() {return Double.NaN;}
        /**
        * Returns the electrical conductivity.
        * @return Unknown
        */
        public double electricalConductivity() {return Double.NaN;}
        /**
        * Returns the thermal conductivity.
        * @return 0.23
        */
        public double thermalConductivity() {return 0.23;}
        /**
        * Returns the chemical symbol.
        * @return Unq
        */
        public String toString() {
                return new String("Unq");
        }
}

