package JSci.chemistry.periodictable;

/**
* A class representing uranium.
* @version 1.5
* @author Mark Hale
*/
public final class Uranium extends RareEarthMetal {
        /**
        * Constructs uranium.
        */
        public Uranium() {}
        /**
        * Returns the atomic number.
        * @return 92
        */
        public int atomicNumber() {return 92;}
        /**
        * Returns the mass number.
        * @return 238
        */
        public int massNumber() {return 238;}
        /**
        * Returns the electronegativity.
        * @return 1.38
        */
        public double electronegativity() {return 1.38;}
        /**
        * Returns the covalent radius.
        * @return 1.42
        */
        public double covalentRadius() {return 1.42;}
        /**
        * Returns the atomic radius.
        * @return Unknown
        */
        public double atomicRadius() {return Double.NaN;}
        /**
        * Returns the melting point.
        * @return 1405.0
        */
        public double meltingPoint() {return 1405.0;}
        /**
        * Returns the boiling point.
        * @return 4407.0
        */
        public double boilingPoint() {return 4407.0;}
        /**
        * Returns the density (293K).
        * @return 18.9
        */
        public double density() {return 18.9;}
        /**
        * Returns the specific heat.
        * @return 0.12
        */
        public double specificHeat() {return 0.12;}
        /**
        * Returns the electrical conductivity.
        * @return 0.038e6
        */
        public double electricalConductivity() {return 0.038e6;}
        /**
        * Returns the thermal conductivity.
        * @return 0.276
        */
        public double thermalConductivity() {return 0.276;}
        /**
        * Returns the chemical symbol.
        * @return U
        */
        public String toString() {
                return new String("U");
        }
}

