package JSci.chemistry.periodictable;

/**
* A class representing ytterbium.
* @version 1.5
* @author Mark Hale
*/
public final class Ytterbium extends RareEarthMetal {
        /**
        * Constructs ytterbium.
        */
        public Ytterbium() {}
        /**
        * Returns the atomic number.
        * @return 70
        */
        public int atomicNumber() {return 70;}
        /**
        * Returns the mass number.
        * @return 173
        */
        public int massNumber() {return 173;}
        /**
        * Returns the electronegativity.
        * @return 1.1
        */
        public double electronegativity() {return 1.1;}
        /**
        * Returns the covalent radius.
        * @return 1.74
        */
        public double covalentRadius() {return 1.74;}
        /**
        * Returns the atomic radius.
        * @return 2.40
        */
        public double atomicRadius() {return 2.40;}
        /**
        * Returns the melting point.
        * @return 1097.0
        */
        public double meltingPoint() {return 1097.0;}
        /**
        * Returns the boiling point.
        * @return 1467.0
        */
        public double boilingPoint() {return 1467.0;}
        /**
        * Returns the density (293K).
        * @return 6.98
        */
        public double density() {return 6.98;}
        /**
        * Returns the specific heat.
        * @return 0.15
        */
        public double specificHeat() {return 0.15;}
        /**
        * Returns the electrical conductivity.
        * @return 0.0351e6
        */
        public double electricalConductivity() {return 0.0351e6;}
        /**
        * Returns the thermal conductivity.
        * @return 0.349
        */
        public double thermalConductivity() {return 0.349;}
        /**
        * Returns the chemical symbol.
        * @return Yb
        */
        public String toString() {
                return new String("Yb");
        }
}

