package JSci.chemistry.periodictable;

/**
* A class representing zinc.
* @version 1.5
* @author Mark Hale
*/
public final class Zinc extends TransitionMetal {
        /**
        * Constructs zinc.
        */
        public Zinc() {}
        /**
        * Returns the atomic number.
        * @return 30
        */
        public int atomicNumber() {return 30;}
        /**
        * Returns the mass number.
        * @return 65
        */
        public int massNumber() {return 65;}
        /**
        * Returns the electronegativity.
        * @return 1.65
        */
        public double electronegativity() {return 1.65;}
        /**
        * Returns the covalent radius.
        * @return 1.25
        */
        public double covalentRadius() {return 1.25;}
        /**
        * Returns the atomic radius.
        * @return 1.53
        */
        public double atomicRadius() {return 1.53;}
        /**
        * Returns the melting point.
        * @return 692.73
        */
        public double meltingPoint() {return 692.73;}
        /**
        * Returns the boiling point.
        * @return 1180.0
        */
        public double boilingPoint() {return 1180.0;}
        /**
        * Returns the density (293K).
        * @return 7.14
        */
        public double density() {return 7.14;}
        /**
        * Returns the specific heat.
        * @return 0.39
        */
        public double specificHeat() {return 0.39;}
        /**
        * Returns the electrical conductivity.
        * @return 0.166e6
        */
        public double electricalConductivity() {return 0.166e6;}
        /**
        * Returns the thermal conductivity.
        * @return 1.16
        */
        public double thermalConductivity() {return 1.16;}
        /**
        * Returns the chemical symbol.
        * @return Zn
        */
        public String toString() {
                return new String("Zn");
        }
}

