package JSci.chemistry.periodictable;

/**
* A class representing zirconium.
* @version 1.5
* @author Mark Hale
*/
public final class Zirconium extends TransitionMetal {
        /**
        * Constructs zirconium.
        */
        public Zirconium() {}
        /**
        * Returns the atomic number.
        * @return 40
        */
        public int atomicNumber() {return 40;}
        /**
        * Returns the mass number.
        * @return 91
        */
        public int massNumber() {return 91;}
        /**
        * Returns the electronegativity.
        * @return 1.33
        */
        public double electronegativity() {return 1.33;}
        /**
        * Returns the covalent radius.
        * @return 1.45
        */
        public double covalentRadius() {return 1.45;}
        /**
        * Returns the atomic radius.
        * @return 2.16
        */
        public double atomicRadius() {return 2.16;}
        /**
        * Returns the melting point.
        * @return 2125.0
        */
        public double meltingPoint() {return 2125.0;}
        /**
        * Returns the boiling point.
        * @return 4682.0
        */
        public double boilingPoint() {return 4682.0;}
        /**
        * Returns the density (293K).
        * @return 6.4
        */
        public double density() {return 6.4;}
        /**
        * Returns the specific heat.
        * @return 0.27
        */
        public double specificHeat() {return 0.27;}
        /**
        * Returns the electrical conductivity.
        * @return 0.0236e6
        */
        public double electricalConductivity() {return 0.0236e6;}
        /**
        * Returns the thermal conductivity.
        * @return 0.227
        */
        public double thermalConductivity() {return 0.227;}
        /**
        * Returns the chemical symbol.
        * @return Zr
        */
        public String toString() {
                return new String("Zr");
        }
}

