package JSci.io;

import java.util.Vector;
import JSci.maths.*;
import JSci.maths.groups.AbelianGroupMember;
import JSci.maths.fields.FieldMember;

/**
* The MathMLExpression class is used by the MathMLParser to
* encapsulate math expressions described by the &lt;apply&gt; tag.
* @version 0.5
* @author Mark Hale
*/
public final class MathMLExpression extends Object {
        private String operation;
        private Vector exp=new Vector();

        /**
        * Constructs a MathML expression.
        */
        public MathMLExpression() {}
        /**
        * Set the operation to be applied to the arguments.
        */
        public void setOperation(String op) {
                operation=op;
        }
        /**
        * Returns the operation to be applied to the arguments.
        */
        public String getOperation() {
                return operation;
        }
        /**
        * Adds an argument to this expression.
        */
        public void addArgument(Object obj) {
                exp.addElement(obj);
        }
        /**
        * Returns an argument from this expression.
        */
        public Object getArgument(int n) {
                return exp.elementAt(n);
        }
        /**
        * Returns the number of arguments.
        */
        public int length() {
                return exp.size();
        }
        /**
        * Substitutes a value for a variable in this expression.
        * @param var the variable to substitute for
        * @param value the value of the variable
        * @return the expression after substitution
        */
        public MathMLExpression substitute(String var,Object value) {
                MathMLExpression subExp=new MathMLExpression();
                subExp.operation=operation;
                Object arg;
                for(int i=0;i<length();i++) {
                        arg=getArgument(i);
                        if(arg instanceof MathMLExpression)
                                arg=((MathMLExpression)arg).substitute(var,value);
                        else if(arg.equals(var))
                                arg=value;
                        subExp.addArgument(arg);
                }
                return subExp;
        }
        /**
        * Evaluates this expression.
        */
        public Object evaluate() {
                Object value=getArgument(0);
                if(value instanceof MathMLExpression)
                        value=((MathMLExpression)value).evaluate();
                if(operation.equals("plus")) {
                        for(int i=1;i<length();i++) {
                                Object next=getArgument(i);
                                if(next instanceof MathMLExpression)
                                        next=((MathMLExpression)next).evaluate();
                                if(value instanceof AbelianGroupMember)
                                        value=((AbelianGroupMember)value).add((AbelianGroupMember)next);
                                else if(value instanceof MathVector)
                                        value=((MathVector)value).add((MathVector)next);
                                else if(value instanceof Matrix)
                                        value=((Matrix)value).add((Matrix)next);
                        }
                } else if(operation.equals("minus")) {
                        for(int i=1;i<length();i++) {
                                Object next=getArgument(i);
                                if(next instanceof MathMLExpression)
                                        next=((MathMLExpression)next).evaluate();
                                if(value instanceof AbelianGroupMember)
                                        value=((AbelianGroupMember)value).subtract((AbelianGroupMember)next);
                                else if(value instanceof MathVector)
                                        value=((MathVector)value).subtract((MathVector)next);
                                else if(value instanceof Matrix)
                                        value=((Matrix)value).subtract((Matrix)next);
                        }
                } else if(operation.equals("multiply")) {
                        for(int i=1;i<length();i++) {
                                Object next=getArgument(i);
                                if(next instanceof MathMLExpression)
                                        next=((MathMLExpression)next).evaluate();
                                if(value instanceof RingMember) {
                                        if(next instanceof RingMember)
                                                value=((RingMember)value).multiply((RingMember)next);
                                        else if(next instanceof MathVector)
                                                value=((MathVector)next).scalarMultiply((RingMember)value);
                                        else if(next instanceof Matrix)
                                                value=((Matrix)next).scalarMultiply((RingMember)value);
                                } else if(value instanceof Matrix) {
                                        if(next instanceof Matrix)
                                                value=((Matrix)value).multiply((Matrix)next);
                                }
                        }
                } else if(operation.equals("divide")) {
                        for(int i=1;i<length();i++) {
                                Object next=getArgument(i);
                                if(next instanceof MathMLExpression)
                                        next=((MathMLExpression)next).evaluate();
                                if(value instanceof FieldMember)
                                        value=((FieldMember)value).divide((FieldMember)next);
                        }
                }
                return value;
        }
}

