package JSci.io;

import java.util.Vector;
import JSci.maths.*;

/**
* The MathMLRelation class is used by the MathMLParser to
* encapsulate math expressions described by the &lt;reln&gt; tag.
* @version 0.3
* @author Mark Hale
*/
public final class MathMLRelation extends Object {
        private String relation;
        private Vector exp=new Vector();

        /**
        * Constructs a MathML relation.
        */
        public MathMLRelation() {}
        /**
        * Set the relation between the arguments.
        */
        public void setRelation(String op) {
                relation=op;
        }
        /**
        * Returns the relation between the arguments.
        */
        public String getRelation() {
                return relation;
        }
        /**
        * Adds an argument to this expression.
        */
        public void addArgument(Object obj) {
                exp.addElement(obj);
        }
        /**
        * Return an argument from this expression.
        */
        public Object getArgument(int n) {
                return exp.elementAt(n);
        }
        /**
        * Returns the number of arguments.
        */
        public int length() {
                return exp.size();
        }
}

