package JSci.maths;

import JSci.GlobalSettings;
import JSci.maths.groups.AbelianGroupMember;

/**
* The MathInteger class encapsulates integer numbers.
* @version 1.0
* @author Mark Hale
*/
public final class MathInteger extends Object implements RingMember, java.io.Serializable {
        private int x;
        /**
        * Constructs an integer number.
        */
        public MathInteger(final int num) {
                x=num;
        }
        /**
        * Constructs the integer number represented by a string.
        * @param s a string representing an integer number
        * @exception NumberFormatException if the string does not contain a parsable number.
        */
        public MathInteger(final String s) throws NumberFormatException {
                x=Integer.valueOf(s).intValue();
        }
        /**
        * Compares two integer numbers for equality.
        * @param obj an integer number
        */
        public boolean equals(Object obj) {
                if(obj!=null && (obj instanceof MathInteger))
                        return x==((MathInteger)obj).value();
                else
                        return false;
        }
        /**
        * Returns a string representing the value of this integer number.
        */
        public String toString() {
                return Integer.toString(x);
        }
        /**
        * Returns the integer value.
        */
        public int value() {
                return x;
        }
        /**
        * Returns the negative of this number.
        */
        public AbelianGroupMember negate() {
                return new MathInteger(-x);
        }
        /**
        * Returns the addition of this number and another.
        */
        public AbelianGroupMember add(final AbelianGroupMember n) {
                if(n instanceof MathInteger)
                        return add((MathInteger)n);
                else
                        throw new IllegalArgumentException("Member class not recognised by this method.");
        }
        /**
        * Returns the addition of this integer number and another.
        */
        public MathInteger add(final MathInteger n) {
                return new MathInteger(x+n.value());
        }
        /**
        * Returns the subtraction of this number and another.
        */
        public AbelianGroupMember subtract(final AbelianGroupMember n) {
                if(n instanceof MathInteger)
                        return subtract((MathInteger)n);
                else
                        throw new IllegalArgumentException("Member class not recognised by this method.");
        }
        /**
        * Returns the subtraction of this integer number and another.
        */
        public MathInteger subtract(final MathInteger n) {
                return new MathInteger(x-n.value());
        }
        /**
        * Returns the multiplication of this number and another.
        */
        public RingMember multiply(final RingMember n) {
                if(n instanceof MathInteger)
                        return multiply((MathInteger)n);
                else
                        throw new IllegalArgumentException("Member class not recognised by this method.");
        }
        /**
        * Returns the multiplication of this integer number and another.
        */
        public MathInteger multiply(final MathInteger n) {
                return new MathInteger(x*n.value());
        }
}

