package JSci.maths.groups;

import JSci.maths.*;

/**
* The DiscreteGroup class provides an abstract encapsulation for discrete groups.
* @version 1.2
* @author Mark Hale
*/
public abstract class DiscreteGroup extends DiscreteSet implements Group {
        /**
        * Constructs a discrete group.
        * @param label a label that identifies this group
        */
        public DiscreteGroup(String label) {
                super(label);
        }
        /**
        * Returns the inverse element.
        */
        public Object inverse(Object a) {
                if(isIdentity(a))
                        return identity();
                else {
                        for(int i=0;i<elements.length;i++) {
                                if(isInverse(a,elements[i]))
                                        return elements[i];
                        }
                        return null;
                }
        }
        /**
        * Returns true if the element is the identity element of this group.
        * @param a a group element
        */
        public final boolean isIdentity(Object a) {
                return identity().equals(a);
        }
        /**
        * Returns true if one element is the inverse of the other.
        * @param a a group element
        * @param b a group element
        */
        public final boolean isInverse(Object a, Object b) {
                return isIdentity(compose(a,b));
        }
}

