package JSci.physics.particles;

import JSci.physics.quantum.QuantumParticle;

/**
* A class representing muons.
* @version 1.5
* @author Mark Hale
*/
public final class Muon extends Lepton {
        /**
        * Constructs a muon.
        */
        public Muon() {}
        /**
        * Returns the rest mass (MeV).
        * @return 105.658389
        */
        public double restMass() {return 105.658389;}
        /**
        * Returns the electric charge.
        * @return -1
        */
        public int charge() {return -1;}
        /**
        * Returns the electron lepton number.
        * @return 0
        */
        public int eLeptonQN() {return 0;}
        /**
        * Returns the muon lepton number.
        * @return 1
        */
        public int muLeptonQN() {return 1;}
        /**
        * Returns the tau lepton number.
        * @return 0
        */
        public int tauLeptonQN() {return 0;}
        /**
        * Returns the antiparticle of this particle.
        */
        public QuantumParticle anti() {
                return new AntiMuon();
        }
        /**
        * Returns true if qp is the antiparticle.
        */
        public boolean isAnti(QuantumParticle qp) {
                return (qp!=null) && (qp instanceof AntiMuon);
        }
        /**
        * Returns a string representing this class.
        */
        public String toString() {
                return new String("Muon");
        }
}

