import java.applet.*;
import java.awt.*;
import JSci.maths.chaos.*;

/**
* Cat map transforms.
* @author Mark Hale
* @version 1.0
*/
public final class CatTransform extends Applet implements Runnable {
        private CatMap cm;
        private int data[][];
        private Thread thr;
        private int xScale,yScale;
        private int iteration;
        public void init() {
                cm=new CatMap();
                data=new int[4][2];
                thr=new Thread(this);
                xScale=getSize().width;
                yScale=getSize().height;
                iteration=0;
        }
        public void start() {
                thr.start();
        }
        public void stop() {
                thr.stop();
        }
        private int dataToScreenX(double x) {
                return (int)Math.round(x*xScale);
        }
        private int dataToScreenY(double y) {
                return (int)Math.round(y*yScale);
        }
        public void run() {
                double x[][]={{0.1,0.1},{0.9,0.1},{0.9,0.9},{0.1,0.9}};
                while(true) {
                        data[0][0]=dataToScreenX(x[0][0]);
                        data[0][1]=dataToScreenY(x[0][1]);
                        data[1][0]=dataToScreenX(x[1][0]);
                        data[1][1]=dataToScreenY(x[1][1]);
                        data[2][0]=dataToScreenX(x[2][0]);
                        data[2][1]=dataToScreenY(x[2][1]);
                        data[3][0]=dataToScreenX(x[3][0]);
                        data[3][1]=dataToScreenY(x[3][1]);
                        repaint();
                        try {
                                Thread.sleep(200);
                        } catch(InterruptedException e) {}
                        x[0]=cm.map(x[0]);
                        x[1]=cm.map(x[1]);
                        x[2]=cm.map(x[2]);
                        x[3]=cm.map(x[3]);
                        iteration++;
                }
        }
        public void paint(Graphics g) {
                showStatus("Iteration = "+iteration);
                g.drawLine(data[0][0],data[0][1],data[1][0],data[1][1]);
                g.drawLine(data[1][0],data[1][1],data[2][0],data[2][1]);
                g.drawLine(data[2][0],data[2][1],data[3][0],data[3][1]);
                g.drawLine(data[3][0],data[3][1],data[0][0],data[0][1]);
        }
}

