import java.awt.*;
import java.awt.event.*;
import JSci.awt.*;
import JSci.maths.*;

/**
* Sample program demonstrating use of LinearMath.leastSquaresFit method
* and the LineTrace graph class.
* @author Mark Hale
* @version 1.0
*/
public final class CurveFitter extends Frame {
        private Label fnLabel=new Label("y = ?",Label.CENTER);
        private LineTrace graph=new LineTrace(-10.0f,10.0f,-10.0f,10.0f);
        private Button fitButton=new Button("Fit");
        private Button clearButton=new Button("Clear");

        public static void main(String arg[]) {
                new CurveFitter();
        }
        public CurveFitter() {
                super("Curve Fitter");
                addWindowListener(new WindowAdapter() {
                        public void windowClosing(WindowEvent evt) {
                                dispose();
                                System.exit(0);
                        }
                });
                fitButton.addActionListener(new ActionListener() {
                        public void actionPerformed(ActionEvent evt) {
                                fitCurve();
                        }
                });
                clearButton.addActionListener(new ActionListener() {
                        public void actionPerformed(ActionEvent evt) {
                                graph.clear();
                        }
                });
                add(fnLabel,"North");
                add(graph,"Center");
                Panel buttonPanel=new Panel();
                buttonPanel.add(fitButton);
                buttonPanel.add(clearButton);
                add(buttonPanel,"South");
                setSize(500,400);
                setVisible(true);
        }
        private void fitCurve() {
                Graph2DModel model=graph.getModel();
                model.firstSeries();
                double data[][]=new double[2][model.seriesLength()];
                for(int i=0;i<data[0].length;i++) {
                        data[0][i]=model.getXCoord(i);
                        data[1][i]=model.getYCoord(i);
                }
                DoubleVector coeffs=LinearMath.leastSquaresFit(4,data);
                StringBuffer poly=new StringBuffer(20);
                poly.append((float)coeffs.getComponent(0));
                for(int i=1;i<coeffs.dimension();i++)
                        poly.append('+').append((float)coeffs.getComponent(i)).append("x^").append(i);
                fnLabel.setText("y = "+poly.toString());
        }
}

