import JSci.maths.*;
import JSci.util.*;

/**
* Class to test eigen methods.
* @author Mark Hale
*/
public class TestEigen {
        public static void main(String arg[]) {
                final int N=5;
                DoubleSquareMatrix m=MatrixToolkit.randomSquareMatrix(N);
                m=(DoubleSquareMatrix)m.add(m.transpose());    // make symmetric
                System.out.println(m.toString()+"det: "+m.det()+"\n");
                double eval[]=new double[N];
                DoubleVector evec[]=new DoubleVector[N];
                try {
                        eval=LinearMath.eigenSolveSymmetric(m,evec);
                } catch(Exception e) {System.out.println("err: "+e.toString());}
                for(int i=0;i<N;i++) {
                        System.out.println(eval[i]+" : "+evec[i].toString());
                        System.out.println(evec[i].scalarMultiply(eval[i]).toString());
                        System.out.println(m.multiply(evec[i]).toString()+"\n");
                }
        }
}

