import JSci.maths.WaveletMath;

/**
* This is a test that verifies perfect reconstruction
* for a signal null near the boundaries (to avoid the
* effects of the zero-padding we used).
* @author Daniel Lemire
*/
public class TestWavelet {
           public static void main(String argv[]) {
        	   double[] data={0,0,0,1,0,0,0,0};
        	   SortieVecteur(data);	
        	   double[] filtre={0.48296291314,0.8365163037,0.224143868,-0.12940952255126};
        	   double[] lowpass=WaveletMath.downsample(filtre,data);
        	   double[] filtreh={-0.12940952255126,-0.224143868,0.8365163037,-0.48296291314};
        	   double[] highpass=WaveletMath.downsample(filtreh,data);
        	   double[] reconstlow=WaveletMath.upsample(filtre,lowpass);
        	   double[] reconsthigh=WaveletMath.upsample(filtreh,highpass);
        	   double[] reconst=new double[data.length];
        	   for(int i=0;i<data.length;i++)
                	   reconst[i]=reconstlow[i]+reconsthigh[i];
		   SortieVecteur(reconst);
	   }
	   private static void SortieVecteur(double[] data){
		   System.out.println("*****");
	           for(int i=0;i<data.length;i++){
			   System.out.println(data[i]);
		   }
 	  }
}

