import java.awt.*;
import java.awt.event.*;
import JSci.chemistry.*;
import JSci.chemistry.periodictable.*;

/**
* Periodic Table.
* @author Mark Hale
* @version 1.2
*/
public final class PeriodicTable extends Frame {
        private GridBagLayout gb=new GridBagLayout();
        private GridBagConstraints gbc=new GridBagConstraints();

        public static void main(String argv[]) {
                new PeriodicTable();
        }
        public PeriodicTable() {
                super("Periodic Table");
                addWindowListener(new WindowAdapter() {
                        public void windowClosing(WindowEvent evt) {
                                dispose();
                                System.exit(0);
                        }
                });
                createTable();
                setSize(650,300);
                setVisible(true);
        }
        private void createTable() {
                gbc.fill=GridBagConstraints.BOTH;
                setLayout(gb);
                gbc.gridx=gbc.gridy=0;
                createButton(new Hydrogen());
                gbc.gridx=17;
                createButton(new Helium());
                gbc.gridx=0;
                gbc.gridy++;
                createButton(new Lithium());
                gbc.gridx=1;
                createButton(new Beryllium());
                gbc.gridx=12;
                createButton(new Boron());
                gbc.gridx++;
                createButton(new Carbon());
                gbc.gridx++;
                createButton(new Nitrogen());
                gbc.gridx++;
                createButton(new Oxygen());
                gbc.gridx++;
                createButton(new Fluorine());
                gbc.gridx++;
                createButton(new Neon());
                gbc.gridx=0;
                gbc.gridy++;
                createButton(new Sodium());
                gbc.gridx=1;
                createButton(new Magnesium());
                gbc.gridx=12;
                createButton(new Aluminium());
                gbc.gridx++;
                createButton(new Silicon());
                gbc.gridx++;
                createButton(new Phosphorus());
                gbc.gridx++;
                createButton(new Sulphur());
                gbc.gridx++;
                createButton(new Chlorine());
                gbc.gridx++;
                createButton(new Argon());
                gbc.gridx=0;
                gbc.gridy++;
                createButton(new Potassium());
                gbc.gridx++;
                createButton(new Calcium());
                gbc.gridx++;
                createButton(new Scandium());
                gbc.gridx++;
                createButton(new Titanium());
                gbc.gridx++;
                createButton(new Vanadium());
                gbc.gridx++;
                createButton(new Chromium());
                gbc.gridx++;
                createButton(new Manganese());
                gbc.gridx++;
                createButton(new Iron());
                gbc.gridx++;
                createButton(new Cobalt());
                gbc.gridx++;
                createButton(new Nickel());
                gbc.gridx++;
                createButton(new Copper());
                gbc.gridx++;
                createButton(new Zinc());
                gbc.gridx++;
                createButton(new Gallium());
                gbc.gridx++;
                createButton(new Germanium());
                gbc.gridx++;
                createButton(new Arsenic());
                gbc.gridx++;
                createButton(new Selenium());
                gbc.gridx++;
                createButton(new Bromine());
                gbc.gridx++;
                createButton(new Krypton());
                gbc.gridx=0;
                gbc.gridy++;
                createButton(new Rubidium());
                gbc.gridx++;
                createButton(new Strontium());
                gbc.gridx++;
                createButton(new Yttrium());
                gbc.gridx++;
                createButton(new Zirconium());
                gbc.gridx++;
                createButton(new Niobium());
                gbc.gridx++;
                createButton(new Molybdenum());
                gbc.gridx++;
                createButton(new Technetium());
                gbc.gridx++;
                createButton(new Ruthenium());
                gbc.gridx++;
                createButton(new Rhodium());
                gbc.gridx++;
                createButton(new Palladium());
                gbc.gridx++;
                createButton(new Silver());
                gbc.gridx++;
                createButton(new Cadmium());
                gbc.gridx++;
                createButton(new Indium());
                gbc.gridx++;
                createButton(new Tin());
                gbc.gridx++;
                createButton(new Antimony());
                gbc.gridx++;
                createButton(new Tellurium());
                gbc.gridx++;
                createButton(new Iodine());
                gbc.gridx++;
                createButton(new Xenon());
                gbc.gridx=0;
                gbc.gridy++;
                createButton(new Caesium());
                gbc.gridx++;
                createButton(new Barium());
                gbc.gridx++;
                createButton(new Lanthanum());
                gbc.gridx++;
                createButton(new Hafnium());
                gbc.gridx++;
                createButton(new Tantalum());
                gbc.gridx++;
                createButton(new Tungsten());
                gbc.gridx++;
                createButton(new Rhenium());
                gbc.gridx++;
                createButton(new Osmium());
                gbc.gridx++;
                createButton(new Iridium());
                gbc.gridx++;
                createButton(new Platinum());
                gbc.gridx++;
                createButton(new Gold());
                gbc.gridx++;
                createButton(new Mercury());
                gbc.gridx++;
                createButton(new Thallium());
                gbc.gridx++;
                createButton(new Lead());
                gbc.gridx++;
                createButton(new Bismuth());
                gbc.gridx++;
                createButton(new Polonium());
                gbc.gridx++;
                createButton(new Astatine());
                gbc.gridx++;
                createButton(new Radon());
                gbc.gridx=0;
                gbc.gridy++;
                createButton(new Francium());
                gbc.gridx++;
                createButton(new Radium());
                gbc.gridx++;
                createButton(new Actinium());
                gbc.gridx++;
                createButton(new Unnilquadium());
                gbc.gridx++;
                createButton(new Unnilpentium());
                gbc.gridx++;
                createButton(new Unnilhexium());
                gbc.gridx++;
                createButton(new Unnilseptium());
                gbc.gridx++;
                createButton(new Unniloctium());
                gbc.gridx++;
                createButton(new Unnilennium());
                gbc.gridx++;
                createButton(new Ununnilium());
                gbc.gridx=0;
                gbc.gridy++;
                Label blankline=new Label("");
                gb.setConstraints(blankline,gbc);
                add(blankline);
                gbc.gridx=2;
                gbc.gridy++;
                createButton(new Cerium());
                gbc.gridx++;
                createButton(new Praseodymium());
                gbc.gridx++;
                createButton(new Neodymium());
                gbc.gridx++;
                createButton(new Promethium());
                gbc.gridx++;
                createButton(new Samarium());
                gbc.gridx++;
                createButton(new Europium());
                gbc.gridx++;
                createButton(new Gadolinium());
                gbc.gridx++;
                createButton(new Terbium());
                gbc.gridx++;
                createButton(new Dysprosium());
                gbc.gridx++;
                createButton(new Holmium());
                gbc.gridx++;
                createButton(new Erbium());
                gbc.gridx++;
                createButton(new Thulium());
                gbc.gridx++;
                createButton(new Ytterbium());
                gbc.gridx++;
                createButton(new Lutetium());
                gbc.gridx=2;
                gbc.gridy++;
                createButton(new Thorium());
                gbc.gridx++;
                createButton(new Protactinium());
                gbc.gridx++;
                createButton(new Uranium());
                gbc.gridx++;
                createButton(new Neptunium());
                gbc.gridx++;
                createButton(new Plutonium());
                gbc.gridx++;
                createButton(new Americium());
                gbc.gridx++;
                createButton(new Curium());
                gbc.gridx++;
                createButton(new Berkelium());
                gbc.gridx++;
                createButton(new Californium());
                gbc.gridx++;
                createButton(new Einsteinium());
                gbc.gridx++;
                createButton(new Fermium());
                gbc.gridx++;
                createButton(new Mendelevium());
                gbc.gridx++;
                createButton(new Nobelium());
                gbc.gridx++;
                createButton(new Lawrencium());
        }
        private void createButton(Element e) {
                Button but=new Button(e.toString());
                but.addActionListener(new ButtonAdapter(this,e));
                gb.setConstraints(but,gbc);
                add(but);
        }
        class ButtonAdapter implements ActionListener {
                private Frame owner;
                private Element element;
                public ButtonAdapter(Frame f,Element e) {
                        owner=f;
                        element=e;
                }
                public void actionPerformed(ActionEvent evt) {
                        new InfoDialog(owner,element);
                }
        }
        static class InfoDialog extends Dialog {
                private static String extractTitle(Element e) {
                        String str=e.getClass().getName();
                        return str.substring(str.lastIndexOf('.')+1);
                }
                private void displayNumber(double x) {
                        if(x==x)
                                add(new Label(String.valueOf(x)));
                        else
                                add(new Label("Unknown"));
                }
                public InfoDialog(Frame parent,Element e) {
                        super(parent,extractTitle(e));
                        addWindowListener(new WindowAdapter() {
                                public void windowClosing(WindowEvent evt) {
                                        dispose();
                                }
                        });
                        setLayout(new GridLayout(11,2));
                        add(new Label("Atomic Number"));
                        add(new Label(String.valueOf(e.atomicNumber())));
                        add(new Label("Mass Number"));
                        add(new Label(String.valueOf(e.massNumber())));
                        add(new Label("Density"));
                        displayNumber(e.density());
                        add(new Label("Boiling Point"));
                        displayNumber(e.boilingPoint());
                        add(new Label("Melting Point"));
                        displayNumber(e.meltingPoint());
                        add(new Label("Atomic Radius"));
                        displayNumber(e.atomicRadius());
                        add(new Label("Covalent Radius"));
                        displayNumber(e.covalentRadius());
                        add(new Label("Electronegativity"));
                        displayNumber(e.electronegativity());
                        add(new Label("Specific Heat"));
                        displayNumber(e.specificHeat());
                        add(new Label("Electrical Conductivity"));
                        displayNumber(e.electricalConductivity());
                        add(new Label("Thermal Conductivity"));
                        displayNumber(e.thermalConductivity());
                        setSize(300,300);
                        setVisible(true);
                }
        }
}

