package JSci.awt;

import java.util.Vector;

/**
* The DefaultGraph2DModel class provides a default implementation
* of the Graph2DModel interface.
* @version 1.0
* @author Mark Hale
*/
public final class DefaultGraph2DModel extends AbstractGraphModel implements Graph2DModel {
        private float xAxis[];
        private final Vector series=new Vector();
        private int pos=0;
        private DataSeries curSeries=null;

        public DefaultGraph2DModel() {}
        public void setXAxis(float x[]) {
                xAxis=new float[x.length];
                System.arraycopy(x,0,xAxis,0,x.length);
                fireDataChanged();
        }
        public void setXAxis(double x[]) {
                xAxis=new float[x.length];
                for(int i=0;i<x.length;i++)
                        xAxis[i]=(float)x[i];
                fireDataChanged();
        }
        public void setXAxis(float a,float b,int n) {
                xAxis=new float[n];
                for(int i=0;i<n;i++)
                        xAxis[i]=(b-a)*i/(n-1)+a;
                fireDataChanged();
        }
        public float[] getXAxis() {
                return xAxis;
        }
        public void addSeries(float newSeries[]) {
                series.addElement(new DataSeries(newSeries));
                fireDataChanged();
        }
        public void addSeries(double newSeries[]) {
                series.addElement(new DataSeries(newSeries));
                fireDataChanged();
        }
        public void changeSeries(int i,float newSeries[]) {
                series.setElementAt(new DataSeries(newSeries),i);
                fireDataChanged();
        }
        public void changeSeries(int i,double newSeries[]) {
                series.setElementAt(new DataSeries(newSeries),i);
                fireDataChanged();
        }
        public void removeSeries(int i) {
                series.removeElementAt(i);
                fireDataChanged();
        }
        public float[] getSeries(int i) {
                return ((DataSeries)series.elementAt(i)).getData();
        }
        public void setSeriesVisible(int i,boolean flag) {
                ((DataSeries)series.elementAt(i)).setVisible(flag);
                fireDataChanged();
        }



        public float getXCoord(int i) {
                return xAxis[i];
        }
        public float getYCoord(int i) {
                return curSeries.getValueAt(i);
        }
        public int seriesLength() {
                return curSeries.length();
        }
        public void firstSeries() {
                curSeries=(DataSeries)series.elementAt(0);
                for(pos=0;!curSeries.isVisible() && pos<series.size()-1;)
                        curSeries=(DataSeries)series.elementAt(++pos);
        }
        public boolean nextSeries() {
                if(pos==series.size()-1)
                        return false;
                do {
                        curSeries=(DataSeries)series.elementAt(++pos);
                } while(!curSeries.isVisible() && pos<series.size()-1);
                return curSeries.isVisible();
        }
}

