package JSci.awt;

import java.awt.*;

/**
* The DoubleBufferedCanvas class provides double buffering functionality.
* @version 1.1
* @author Mark Hale
*/
public abstract class DoubleBufferedCanvas extends Canvas {
        private Image buffer=null;
        /**
        * Constructs a double buffered canvas.
        */
        public DoubleBufferedCanvas() {}
        /**
        * Paints the canvas using double buffering.
        * @see #offscreenPaint
        */
        public final void paint(Graphics g) {
                if(buffer==null) {
                        buffer=createImage(getSize().width,getSize().height);
                        offscreenPaint(buffer.getGraphics());
                }
                g.drawImage(buffer,0,0,this);
        }
        /**
        * Updates the canvas.
        */
        public final void update(Graphics g) {
                paint(g);
        }
        /**
        * Redraws the canvas.
        */
        public final void redraw() {
                buffer=null;
                repaint();
        }
        /**
        * Paints the canvas off-screen.
        * Override this method instead of paint(Graphics g).
        */
        protected abstract void offscreenPaint(Graphics g);
}

