package JSci.awt;

import java.awt.*;

/**
* A line graph AWT component.
* @version 1.0
* @author Mark Hale
*/
public class LineGraph extends Graph2D {
        /**
        * Line colors.
        */
        private Color lineColor[]={Color.black,Color.blue,Color.green,Color.red,Color.yellow,Color.cyan,Color.lightGray,Color.magenta,Color.orange,Color.pink};
        /**
        * Constructs a line graph.
        */
        public LineGraph(Graph2DModel gm) {
                super(gm);
                dataChanged(new GraphDataEvent(model));
        }
        /**
        * Implementation of GraphDataListener.
        */
        public void dataChanged(GraphDataEvent e) {
                int i,n;
                float tmpX,tmpY;
                minX=maxX=minY=maxY=0.0f;
                model.firstSeries();
                for(i=0;i<model.seriesLength();i++) {
                        tmpX=model.getXCoord(i);
                        if(tmpX>maxX)
                                maxX=tmpX;
                        else if(tmpX<minX)
                                minX=tmpX;
                        tmpY=model.getYCoord(i);
                        if(tmpY>maxY)
                                maxY=tmpY;
                        else if(tmpY<minY)
                                minY=tmpY;
                }
                for(n=1;model.nextSeries();n++) {
                        for(i=0;i<model.seriesLength();i++) {
                                tmpY=model.getYCoord(i);
                                if(tmpY>maxY)
                                        maxY=tmpY;
                                else if(tmpY<minY)
                                        minY=tmpY;
                        }
                }
                if(maxY==minY)
                        maxY=1.0f;
                if(n>lineColor.length) {
                        Color tmp[]=lineColor;
                        lineColor=new Color[n];
                        System.arraycopy(tmp,0,lineColor,0,tmp.length);
                        for(i=tmp.length;i<n;i++)
                                lineColor[i]=lineColor[i-tmp.length];
                }
                rescale();
        }
        /**
        * Sets the line color of the nth y-series.
        * @param n the index of the y-series
        * @param c the line color
        */
        public void setColor(int n,Color c) {
                lineColor[n]=c;
        }
        /**
        * Sets the minimum/maximum values on the y-axis.
        * @author Daniel Lemire
        */
        public void setYExtrema(float min,float max) {
                if(max<min)
                        throw new IllegalArgumentException("Maximum should be greater than minimum; max = "+max+" and min = "+min);
                minY=min;
                maxY=max;
                rescale();
        }
        /**
        * Returns the preferred size of this component.
        */
        public Dimension getPreferredSize() {
                return getMinimumSize();
        }
        /**
        * Returns the minimum size of this component.
        */
        public Dimension getMinimumSize() {
                return new Dimension(250,250);
        }
        /**
        * Paint the graph.
        */
        protected void offscreenPaint(Graphics g) {
                drawAxes(g);
// lines
                Point p1,p2;
                model.firstSeries();
                g.setColor(lineColor[0]);
                p1=dataToScreen(model.getXCoord(0),model.getYCoord(0));
                int i;
                for(i=1;i<model.seriesLength();i++) {
                        p2=dataToScreen(model.getXCoord(i),model.getYCoord(i));
                        g.drawLine(p1.x,p1.y,p2.x,p2.y);
                        p1=p2;
                }
                for(int n=1;model.nextSeries();n++) {
                        g.setColor(lineColor[n]);
                        p1=dataToScreen(model.getXCoord(0),model.getYCoord(0));
                        for(i=1;i<model.seriesLength();i++) {
                                p2=dataToScreen(model.getXCoord(i),model.getYCoord(i));
                                g.drawLine(p1.x,p1.y,p2.x,p2.y);
                                p1=p2;
                        }
                }
        }
}

