package JSci.awt;

import java.awt.*;

/**
* A pie chart AWT component.
* @version 1.1
* @author Mark Hale
*/
public class PieChart extends CategoryGraph2D {
        /**
        * Total value of pie.
        */
        private float pieTotal;
        /**
        * Slice colors.
        */
        private Color sliceColor[]={Color.blue,Color.green,Color.red,Color.yellow,Color.cyan,Color.lightGray,Color.magenta,Color.orange,Color.pink};
        /**
        * Padding.
        */
        private final int borderPad=30;
        /**
        * Constructs a pie chart.
        */
        public PieChart(CategoryGraph2DModel cgm) {
                super(cgm);
                dataChanged(new GraphDataEvent(model));
        }
        /**
        * Implementation of GraphDataListener.
        */
        public void dataChanged(GraphDataEvent e) {
                model.firstSeries();
                final int len=model.seriesLength();
                pieTotal=0.0f;
                for(int i=0;i<len;i++)
                        pieTotal+=model.getValue(i);
                if(len>sliceColor.length) {
                        Color tmp[]=sliceColor;
                        sliceColor=new Color[len];
                        System.arraycopy(tmp,0,sliceColor,0,tmp.length);
                        for(int i=tmp.length;i<sliceColor.length;i++)
                                sliceColor[i]=sliceColor[i-tmp.length];
                }
                rescale();
        }
        /**
        * Sets the slice color of the nth slice.
        * @param n the index of the slice
        * @param c the slice color
        */
        public void setColor(int n,Color c) {
                sliceColor[n]=c;
        }
        /**
        * Returns the preferred size of this component.
        */
        public Dimension getPreferredSize() {
                return getMinimumSize();
        }
        /**
        * Returns the minimum size of this component.
        */
        public Dimension getMinimumSize() {
                return new Dimension(250,250);
        }
        /**
        * Reshapes the PieChart to the specified bounding box.
        */
        public void setBounds(int x,int y,int width,int height) {
                super.setBounds(x,y,width,height);
                rescale();
        }
        /**
        * Rescales the PieChart.
        */
        private void rescale() {
                redraw();
        }
        /**
        * Paint the graph.
        */
        protected void offscreenPaint(Graphics g) {
                final int originX=getSize().width/2;
                final int originY=getSize().height/2;
                final int width=2*(originX-borderPad);
                final int height=2*(originY-borderPad);
                final double xRadius=0.4*width;
                final double yRadius=0.4*height;
// slices
                int i,arcAngle,angle=0;
                model.firstSeries();
                for(i=0;i<model.seriesLength()-1;i++) {
                        g.setColor(sliceColor[i]);
                        arcAngle=Math.round(model.getValue(i)*360.0f/pieTotal);
                        g.fillArc(borderPad,borderPad,width,height,angle,arcAngle);
                        angle+=arcAngle;
                }
                g.setColor(sliceColor[i]);
                g.fillArc(borderPad,borderPad,width,height,angle,360-angle);
// labels
                int strHalfWidth;
                final int strHalfHeight=g.getFontMetrics().getHeight()/2;
                double dHalfArcAngle,dAngle=0.0;
                g.setColor(Color.black);
                for(i=0;i<model.seriesLength();i++) {
                        dHalfArcAngle=model.getValue(i)*Math.PI/pieTotal;
                        dAngle+=dHalfArcAngle;
                        strHalfWidth=g.getFontMetrics().stringWidth(model.getCategory(i))/2;
                        g.drawString(model.getCategory(i),originX-strHalfWidth+(int)(xRadius*Math.cos(dAngle)),originY+strHalfHeight-(int)(yRadius*Math.sin(dAngle)));
                        dAngle+=dHalfArcAngle;
                }
        }
}

