package JSci.awt;

import java.awt.*;

/**
* A scatter graph AWT component.
* @version 1.0
* @author Mark Hale
*/
public class ScatterGraph extends Graph2D {
        /**
        * Constructs a scatter graph.
        */
        public ScatterGraph(Graph2DModel gm) {
                super(gm);
                dataChanged(new GraphDataEvent(model));
        }
        /**
        * Implementation of GraphDataListener.
        */
        public void dataChanged(GraphDataEvent e) {
                int i;
                float tmpX,tmpY;
                minX=maxX=minY=maxY=0.0f;
                model.firstSeries();
                for(i=0;i<model.seriesLength();i++) {
                        tmpX=model.getXCoord(i);
                        if(tmpX>maxX)
                                maxX=tmpX;
                        else if(tmpX<minX)
                                minX=tmpX;
                        tmpY=model.getYCoord(i);
                        if(tmpY>maxY)
                                maxY=tmpY;
                        else if(tmpY<minY)
                                minY=tmpY;
                }
                if(maxY==minY)
                        maxY=1.0f;
                rescale();
        }
        /**
        * Returns the preferred size of this component.
        */
        public Dimension getPreferredSize() {
                return getMinimumSize();
        }
        /**
        * Returns the minimum size of this component.
        */
        public Dimension getMinimumSize() {
                return new Dimension(250,250);
        }
        /**
        * Paint the graph.
        */
        protected void offscreenPaint(Graphics g) {
                drawAxes(g);
// points
                Point p;
                model.firstSeries();
                for(int i=0;i<model.seriesLength();i++) {
                        p=dataToScreen(model.getXCoord(i),model.getYCoord(i));
                        g.fillRect(p.x,p.y,1,1);
                }
        }
}

