package JSci.chemistry.periodictable;

/**
* A class representing aluminium.
* @version 1.5
* @author Mark Hale
*/
public final class Aluminium extends Metal {
        /**
        * Constructs aluminium.
        */
        public Aluminium() {}
        /**
        * Returns the atomic number.
        * @return 13
        */
        public int atomicNumber() {return 13;}
        /**
        * Returns the mass number.
        * @return 27
        */
        public int massNumber() {return 27;}
        /**
        * Returns the electronegativity.
        * @return 1.61
        */
        public double electronegativity() {return 1.61;}
        /**
        * Returns the covalent radius.
        * @return 1.25
        */
        public double covalentRadius() {return 1.25;}
        /**
        * Returns the atomic radius.
        * @return 1.82
        */
        public double atomicRadius() {return 1.82;}
        /**
        * Returns the melting point.
        * @return 933.25
        */
        public double meltingPoint() {return 933.25;}
        /**
        * Returns the boiling point.
        * @return 2793
        */
        public double boilingPoint() {return 2793;}
        /**
        * Returns the density (293K).
        * @return 2.702
        */
        public double density() {return 2.702;}
        /**
        * Returns the specific heat.
        * @return 0.9
        */
        public double specificHeat() {return 0.9;}
        /**
        * Returns the electrical conductivity.
        * @return 0.377e6
        */
        public double electricalConductivity() {return 0.377e6;}
        /**
        * Returns the thermal conductivity.
        * @return 2.37
        */
        public double thermalConductivity() {return 2.37;}
        /**
        * Returns the chemical symbol.
        * @return Al
        */
        public String toString() {
                return new String("Al");
        }
}

