package JSci.chemistry.periodictable;

/**
* A class representing antimony.
* @version 1.5
* @author Mark Hale
*/
public final class Antimony extends Metal {
        /**
        * Constructs antimony.
        */
        public Antimony() {}
        /**
        * Returns the atomic number.
        * @return 51
        */
        public int atomicNumber() {return 51;}
        /**
        * Returns the mass number.
        * @return 122
        */
        public int massNumber() {return 122;}
        /**
        * Returns the electronegativity.
        * @return 2.05
        */
        public double electronegativity() {return 2.05;}
        /**
        * Returns the covalent radius.
        * @return 1.41
        */
        public double covalentRadius() {return 1.41;}
        /**
        * Returns the atomic radius.
        * @return 1.53
        */
        public double atomicRadius() {return 1.53;}
        /**
        * Returns the melting point.
        * @return 904
        */
        public double meltingPoint() {return 904;}
        /**
        * Returns the boiling point.
        * @return 1860
        */
        public double boilingPoint() {return 1860;}
        /**
        * Returns the density (293K).
        * @return 6.684
        */
        public double density() {return 6.684;}
        /**
        * Returns the specific heat.
        * @return 0.21
        */
        public double specificHeat() {return 0.21;}
        /**
        * Returns the electrical conductivity.
        * @return 0.0288e6
        */
        public double electricalConductivity() {return 0.0288e6;}
        /**
        * Returns the thermal conductivity.
        * @return 0.243
        */
        public double thermalConductivity() {return 0.243;}
        /**
        * Returns the chemical symbol.
        * @return Sb
        */
        public String toString() {
                return new String("Sb");
        }
}

