package JSci.chemistry.periodictable;

/**
* A class representing barium.
* @version 1.5
* @author Mark Hale
*/
public final class Barium extends AlkaliEarthMetal {
        /**
        * Constructs barium.
        */
        public Barium() {}
        /**
        * Returns the atomic number.
        * @return 56
        */
        public int atomicNumber() {return 56;}
        /**
        * Returns the mass number.
        * @return 137
        */
        public int massNumber() {return 137;}
        /**
        * Returns the electronegativity.
        * @return 0.89
        */
        public double electronegativity() {return 0.89;}
        /**
        * Returns the covalent radius.
        * @return 1.98
        */
        public double covalentRadius() {return 1.98;}
        /**
        * Returns the atomic radius.
        * @return 2.78
        */
        public double atomicRadius() {return 2.78;}
        /**
        * Returns the melting point.
        * @return 1002
        */
        public double meltingPoint() {return 1002;}
        /**
        * Returns the boiling point.
        * @return 2171
        */
        public double boilingPoint() {return 2171;}
        /**
        * Density (293K).
        * @return 3.51
        */
        public double density() {return 3.51;}
        /**
        * Returns the specific heat.
        * @return 0.204
        */
        public double specificHeat() {return 0.204;}
        /**
        * Returns the electrical conductivity.
        * @return 0.030e6
        */
        public double electricalConductivity() {return 0.030e6;}
        /**
        * Returns the thermal conductivity.
        * @return 0.184
        */
        public double thermalConductivity() {return 0.184;}
        /**
        * Returns the chemical symbol.
        * @return Ba
        */
        public String toString() {
                return new String("Ba");
        }
}

