package JSci.chemistry.periodictable;

/**
* A class representing bismuth.
* @version 1.5
* @author Mark Hale
*/
public final class Bismuth extends Metal {
        /**
        * Constructs bismuth.
        */
        public Bismuth() {}
        /**
        * Returns the atomic number.
        * @return 83
        */
        public int atomicNumber() {return 83;}
        /**
        * Returns the mass number.
        * @return 209
        */
        public int massNumber() {return 209;}
        /**
        * Returns the electronegativity.
        * @return 2.02
        */
        public double electronegativity() {return 2.02;}
        /**
        * Returns the covalent radius.
        * @return 1.52
        */
        public double covalentRadius() {return 1.52;}
        /**
        * Returns the atomic radius.
        * @return 1.63
        */
        public double atomicRadius() {return 1.63;}
        /**
        * Returns the melting point.
        * @return 544.52
        */
        public double meltingPoint() {return 544.52;}
        /**
        * Returns the boiling point.
        * @return 1837
        */
        public double boilingPoint() {return 1837;}
        /**
        * Returns the density (293K).
        * @return 9.8
        */
        public double density() {return 9.8;}
        /**
        * Returns the specific heat.
        * @return 0.12
        */
        public double specificHeat() {return 0.12;}
        /**
        * Returns the electrical conductivity.
        * @return 8.67e3
        */
        public double electricalConductivity() {return 8.67e3;}
        /**
        * Returns the thermal conductivity.
        * @return 0.078
        */
        public double thermalConductivity() {return 0.078;}
        /**
        * Returns the chemical symbol.
        * @return Bi
        */
        public String toString() {
                return new String("Bi");
        }
}

